const mujianSdk = new window.MujianUMD.MujianSdk();
const stopController = new AbortController();

// 发送消息。入参是用户输入
async function send(query) {
	const id = Date.now();
	addMessage("assistant", "等待回复中...", id); // 添加一个占位的AI消息。用于后续刷返回文字
	startLoading(id); // 给消息添加loading状态
	await mujianSdk.ai.chat.complete( // 调用 mujian sdk 发送请求
		query,
		(res) => {
			updateMessage(id, res.fullContent); // 流式实时更新消息
			if (res.isFinished) { // 如果流式完成结束，则停止loading状态
				stopLoading(id); // 停止loading状态
			}
		},
		stopController.signal,
		{
			parseContent: true, // 让 sdk 只返回消息内容，不会返回其他字段
		},
	);
}

// 停止发送消息
function stop() {
	stopController.abort();
}

// 渲染所有消息
async function renderAllMessages() {
	const messages = await mujianSdk.ai.chat.message.getAll(); // 通过 sdk 获取所有消息
	renderMessages(messages); // 渲染所有消息
	scrollToBottom(); // 滚动到底部
}

// 更新消息。入参是消息id和消息内容
function updateMessage(id, message) {
	if ($(`#message-assistant-${id}`).length === 0) { // 如果消息不存在，则返回
		return;
	}
	$(`#message-assistant-${id}`).text("assistant: " + message); // 更新消息内容
	scrollToBottom(); // 滚动到底部
}

// 添加消息。入参是消息角色和消息内容
function addMessage(role, message, id = null) {
	const _id = id || Date.now(); // 如果消息id不存在，则生成一个唯一id
	$("#messages").append(
		`<div id="message-${role}-${_id}" class="message ${role === "user" ? "user" : "assistant"}">${role}: ${message}</div>`, // 添加消息
	);
}

function startLoading(id) {
	$(`#message-assistant-${id}`).addClass("loading");
}

function stopLoading(id) {
	$(`#message-assistant-${id}`).removeClass("loading");
}

function clearMessages() {
	$("#messages").empty();
}

function scrollToBottom() {
	$("#messages").animate(
		{ scrollTop: $("#messages").prop("scrollHeight") },
		100,
	);
}

// 渲染消息。入参是消息列表
function renderMessages(messages) {
	// console.log("messages", messages);
	messages.forEach((message) => {
		// 添加消息
		addMessage(message.role, message.content, message.id);
	});
}

// 发送消息。点击发送按钮时，获取用户输入，并发送消息
$("#send").click(async () => {
	const query = $("#input").val(); // 获取用户输入
	if (!query) { // 如果用户输入为空，则返回
		return;
	}
	$("#input").val(""); // 清空用户输入
	addMessage("user", query, Date.now()); // 添加用户消息
	await send(query); // 发送消息
});

$("#stop").click(stop); // 点击停止按钮时，停止发送消息


// 初始化。初始化幕间官方SDK
(async () => {
	await mujianSdk.init().then(async () => {
		await renderAllMessages(); // 渲染所有消息
	});
})();
