const mujianSdk = new window.MujianUMD.MujianSdk();

mujianSdk.init().then(() => {
	console.log("init success");
	mujianSdk.ai.chat.project.getInfo().then((res) => {
		console.log("getProjectInfo success", res);
		window.document.getElementById("project-info").innerHTML =
			`<pre>${JSON.stringify(res, null, 2)}</pre>`;
		window.document.getElementById("project-info-img").src = res.coverImageUrl;
	});

	mujianSdk.ai.chat.settings.persona.getActive().then((res) => {
		console.log("getPersonaInfo success", res);
		// 支持 JQuery 操作页面元素
		$("#persona-info").html(JSON.stringify(res));
	});

	$("#text-completion-button").click(async () => {
		$("#text-completion-result").html("");
		const res = await mujianSdk.ai.openai.completions.create({
			prompt: "Hello, world!",
		});
		console.log("text completion success", res);
		$("#text-completion-result").html(JSON.stringify(res));
	});

	$("#chat-completion-button").click(async () => {
		$("#chat-completion-result").html("");
		const res = await mujianSdk.ai.openai.chat.completions.create({
			messages: [{ role: "user", content: "Hello, world!" }],
		});
		console.log("chat completion success", res);
		$("#chat-completion-result").html(JSON.stringify(res));
	});

	// 文字补全流式
	$("#text-completion-stream-button").click(async () => {
		$("#text-completion-stream-result").html("");
		const res = await mujianSdk.ai.openai.completions.create(
			{
				prompt: "给我讲个100字的故事",
				stream: true,
			},
			{},
			(data) => {
				console.log("text completion stream data", data);
				$("#text-completion-stream-result").append(data?.choices?.[0]?.text);
			},
		);
	});

	// 对话补全流式
	$("#chat-completion-stream-button").click(async () => {
		$("#chat-completion-stream-result").html("");
		const res = await mujianSdk.ai.openai.chat.completions.create(
			{
				messages: [{ role: "user", content: "给我讲个100字的故事" }],
				stream: true,
			},
			{},
			(data) => {
				console.log("chat completion stream data", data);
				$("#chat-completion-stream-result").append(
					data?.choices?.[0]?.delta?.content,
				);
			},
		);
	});

	// Responses 非流式
	$("#responses-button").click(async () => {
		$("#responses-result").html("");
		const res = await mujianSdk.ai.openai.responses.create({
			input: [
				{
					type: "message",
					role: "user",
					content: [
						{
							type: "input_text",
							text: "给我讲个100字的故事",
						},
					],
				},
			],
		});
		console.log("responses success", res);
		$("#responses-result").html(res?.output?.[0]?.content?.[0]?.text);
	});

	// Responses 流式
	$("#responses-stream-button").click(async () => {
		$("#responses-stream-result").html("");
		const res = await mujianSdk.ai.openai.responses.create(
			{
				input: [
					{
						type: "message",
						role: "user",
						content: [
							{
								type: "input_text",
								text: "给我讲个100字的故事",
							},
						],
					},
				],
				stream: true,
			},
			{},
			(data) => {
				// console.log("responses stream data", data);
				$("#responses-stream-result").append(data?.delta);
			},
		);
	});

	$("#image-generation-button").click(async () => {
		$("#image-generation-result").html("");
		const res = await mujianSdk.ai.openai.images.generate({
			prompt: "A beautiful sunset over a calm ocean",
		});
		console.log("image generation success", res?.choices?.[0]?.images);
		for (const image of res?.choices?.[0]?.images || []) {
			$("#image-generation-result").append(
				`<img src="${image.image_url?.url}" alt="图像生成结果" style="max-width: 100%; height: auto; margin: 10px; border-radius: 8px;" />`,
			);
		}
	});

	$("#image-generation-stream-button").click(async () => {
		$("#image-generation-stream-result").html("");
		await mujianSdk.ai.openai.images.generate(
			{
				prompt:
					"Create two images, one is a beautiful sunset over a calm ocean, the other is a beautiful sunrise over a calm ocean",
				stream: true,
			},
			{},
			(data) => {
				console.log("image generation stream data", data);
				if (data?.choices?.[0]?.images) {
					$("#image-generation-stream-result").append(
						`<img src="${data?.choices?.[0]?.images?.[0]?.image_url?.url}" alt="图像生成结果" style="max-width: 100%; height: auto; margin: 10px; border-radius: 8px;" />`,
					);
				}
			},
		);
	});

	$("#tool-call-button").click(async () => {
		$("#tool-call-result").html("");

		const weatherTool = {
			type: "function",
			function: {
				name: "get_weather",
				description: "Get the current weather in a location",
				parameters: {
					type: "object",
					properties: {
						location: {
							type: "string",
							description: "The city and state, e.g. San Francisco, CA",
						},
						unit: {
							type: "string",
							enum: ["celsius", "fahrenheit"],
							description: "The unit of temperature, e.g. celsius, fahrenheit",
							default: "celsius",
						},
					},
					required: ["location"],
				},
			},
		};

		const get_weather = async (location, unit) => {
			console.log("get_weather", location, unit);
			return {
				weather: "sunny",
				temperature: 20,
				unit: unit,
			};
		};

		const TOOL_MAPPING = {
			get_weather,
		};

		const res = await mujianSdk.ai.openai.chat.completions.create({
			messages: [
				{
					role: "system",
					content: "You are a helpful assistant.",
				},
				{
					role: "user",
					content: "What is the weather in San Francisco? in fahrenheit",
				},
			],
			tools: [weatherTool],
			tool_choice: "auto",
			max_output_tokens: 9000,
		});
		console.log("tool call success", res);
		$("#tool-call-result").html(JSON.stringify(res));
		const msg = res.choices[0].message;

		for (const toolCall of msg?.tool_calls || []) {
			const toolName = toolCall.function.name;
			const { location, unit } = JSON.parse(toolCall.function.arguments);
			const toolResponse = await TOOL_MAPPING[toolName](location, unit);
			console.log("tool response", toolResponse);
		}
	});
});
